/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.security;

import com.tvd12.ezyfox.function.EzyBytesFunction;
import com.tvd12.ezyfox.security.EzyBase64;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;

public class EzyAsyCrypt {
    protected final Cipher cipher;
    protected final byte[] publicKey;
    protected final byte[] privateKey;
    protected final KeyFactory keyFactory;
    public static final String DEFAULT_ALGORITHM = "RSA";
    public static final String TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    protected static final Map<Class<?>, EzyBytesFunction<Object>> BYTES_CONVERTERS = EzyAsyCrypt.defaultBytesConverters();

    protected EzyAsyCrypt(Builder<?> builder) {
        try {
            this.cipher = builder.newCipher();
            this.publicKey = builder.getPublicKey();
            this.privateKey = builder.getPrivateKey();
            this.keyFactory = builder.newKeyFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("init asymmetric encryption error", e);
        }
    }

    public byte[] encrypt(byte[] data) throws Exception {
        this.cipher.init(1, this.getPublicKey());
        return this.cipher.doFinal(data);
    }

    public <T> T encrypt(byte[] data, Class<T> outType) throws Exception {
        byte[] bytes = this.encrypt(data);
        return this.convertBytes(bytes, outType);
    }

    public byte[] encrypt(String data) throws Exception {
        return this.encrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    public <T> T encrypt(String data, Class<T> outType) throws Exception {
        return this.encrypt(data.getBytes(StandardCharsets.UTF_8), outType);
    }

    public byte[] decrypt(byte[] data) throws Exception {
        this.cipher.init(2, this.getPrivateKey());
        return this.cipher.doFinal(data);
    }

    public <T> T decrypt(byte[] data, Class<T> outType) throws Exception {
        byte[] bytes = this.decrypt(data);
        return this.convertBytes(bytes, outType);
    }

    public byte[] decrypt(String data) throws Exception {
        return this.decrypt(EzyBase64.decode(data));
    }

    public <T> T decrypt(String data, Class<T> outType) throws Exception {
        return this.decrypt(EzyBase64.decode(data), outType);
    }

    protected <T> T convertBytes(byte[] bytes, Class<T> outType) {
        return (T)this.getBytesConverters().get(outType).apply(bytes);
    }

    protected Map<Class, EzyBytesFunction> getBytesConverters() {
        return BYTES_CONVERTERS;
    }

    protected PrivateKey getPrivateKey() throws Exception {
        return this.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.privateKey));
    }

    protected PublicKey getPublicKey() throws Exception {
        return this.keyFactory.generatePublic(new X509EncodedKeySpec(this.publicKey));
    }

    private static Map<Class<?>, EzyBytesFunction<Object>> defaultBytesConverters() {
        ConcurrentHashMap answer = new ConcurrentHashMap();
        answer.put(byte[].class, bytes -> bytes);
        answer.put(String.class, EzyBase64::encode2utf);
        return answer;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>> {
        protected byte[] publicKey;
        protected byte[] privateKey;
        protected String algorithm = "RSA";
        protected String transformation = "RSA/ECB/PKCS1Padding";

        public B algorithm(String algorithm) {
            this.algorithm = algorithm;
            return (B)this;
        }

        public B transformation(String transformation) {
            this.transformation = transformation;
            return (B)this;
        }

        public B publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return (B)this;
        }

        public B privateKey(byte[] privateKey) {
            this.privateKey = privateKey;
            return (B)this;
        }

        protected byte[] getPublicKey() {
            return this.publicKey;
        }

        protected byte[] getPrivateKey() {
            return this.privateKey;
        }

        public EzyAsyCrypt build() {
            return new EzyAsyCrypt(this);
        }

        protected Cipher newCipher() throws Exception {
            return Cipher.getInstance(this.transformation);
        }

        protected KeyFactory newKeyFactory() throws Exception {
            return KeyFactory.getInstance(this.algorithm);
        }
    }
}

