/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb.converter;

import com.tvd12.ezydata.mongodb.converter.EzyMongoBsonValueToData;
import com.tvd12.ezydata.mongodb.converter.EzyMongoBsonValueToString;
import com.tvd12.ezydata.mongodb.converter.EzyMongoDataToBsonValue;
import com.tvd12.ezyfox.builder.EzyBuilder;
import org.bson.BsonValue;

public class EzyMongoDataConverter {
    protected final EzyMongoDataToBsonValue dataToBsonValue;
    protected final EzyMongoBsonValueToData bsonValueToData;
    protected final EzyMongoBsonValueToString bsonValueToString;

    protected EzyMongoDataConverter(Builder builder) {
        this.dataToBsonValue = builder.dataToBsonValue;
        this.bsonValueToData = builder.bsonValueToData;
        this.bsonValueToString = builder.bsonValueToString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String bsonValueToString(BsonValue value) {
        return this.bsonValueToString.convert(value);
    }

    public <T> T bsonValueToData(BsonValue value) {
        Object data = this.bsonValueToData.convert(value);
        return (T)data;
    }

    public <T extends BsonValue> T dataToBsonValue(Object data) {
        BsonValue value = this.dataToBsonValue.convert(data);
        return (T)value;
    }

    public static class Builder
    implements EzyBuilder<EzyMongoDataConverter> {
        protected EzyMongoDataToBsonValue dataToBsonValue;
        protected EzyMongoBsonValueToData bsonValueToData;
        protected EzyMongoBsonValueToString bsonValueToString;

        public Builder dataToBsonValue(EzyMongoDataToBsonValue dataToBsonValue) {
            this.dataToBsonValue = dataToBsonValue;
            return this;
        }

        public Builder bsonValueToData(EzyMongoBsonValueToData bsonValueToData) {
            this.bsonValueToData = bsonValueToData;
            return this;
        }

        public Builder bsonValueToString(EzyMongoBsonValueToString bsonValueToString) {
            this.bsonValueToString = bsonValueToString;
            return this;
        }

        public EzyMongoDataConverter build() {
            if (this.bsonValueToString == null) {
                this.bsonValueToString = new EzyMongoBsonValueToString();
            }
            if (this.dataToBsonValue == null) {
                this.dataToBsonValue = new EzyMongoDataToBsonValue();
            }
            if (this.bsonValueToData == null) {
                this.bsonValueToData = new EzyMongoBsonValueToData();
            }
            return new EzyMongoDataConverter(this);
        }
    }
}

