/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb.converter;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.io.EzyDates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class EzyMongoDataToBsonValue {
    protected final Map<Class, Function<Object, BsonValue>> converters = this.defaultConverters();

    public void addConverter(Class<?> dataType, Function<Object, BsonValue> converter) {
        this.converters.put(dataType, converter);
    }

    public BsonValue convert(Object data) {
        if (data == null) {
            return BsonNull.VALUE;
        }
        if (data instanceof ObjectId) {
            return new BsonObjectId((ObjectId)data);
        }
        if (data instanceof BsonValue) {
            return (BsonValue)data;
        }
        Class<?> valueType = data.getClass();
        Function<Object, BsonValue> converter = this.converters.get(valueType);
        if (converter != null) {
            return converter.apply(data);
        }
        if (data instanceof Iterable) {
            BsonArray array = new BsonArray();
            for (Object item : (Iterable)data) {
                array.add(this.convert(item));
            }
            return array;
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            BsonDocument document = new BsonDocument();
            for (Object k : map.keySet()) {
                this.putKeyValue(document, k, map.get(k));
            }
            return document;
        }
        if (data instanceof EzyArray) {
            EzyArray coll = (EzyArray)data;
            BsonArray array = new BsonArray();
            for (int i = 0; i < coll.size(); ++i) {
                array.add(this.convert(coll.get(i)));
            }
            return array;
        }
        if (data instanceof EzyObject) {
            EzyObject obj = (EzyObject)data;
            BsonDocument document = new BsonDocument();
            for (Object k : obj.keySet()) {
                this.putKeyValue(document, k, obj.get(k));
            }
            return document;
        }
        if (data instanceof Object[]) {
            BsonArray array = new BsonArray();
            for (Object item : (Object[])data) {
                array.add(this.convert(item));
            }
            return array;
        }
        if (valueType.isEnum()) {
            return new BsonString(data.toString());
        }
        throw new IllegalArgumentException("has no converter for: " + valueType.getName());
    }

    protected void putKeyValue(BsonDocument document, Object key, Object value) {
        BsonValue ck = this.convert(key);
        String keyString = ck instanceof BsonDocument ? ((BsonDocument)ck).toJson() : (ck instanceof BsonString ? ((BsonString)ck).getValue() : ck.toString());
        BsonValue cv = this.convert(value);
        document.put(keyString, cv);
    }

    protected Map<Class, Function<Object, BsonValue>> defaultConverters() {
        HashMap<Class, Function<Object, BsonValue>> map = new HashMap<Class, Function<Object, BsonValue>>();
        map.put(Boolean.class, v -> new BsonBoolean(((Boolean)v).booleanValue()));
        map.put(Byte.class, v -> new BsonInt32((int)((Byte)v).byteValue()));
        map.put(Character.class, v -> new BsonInt32((int)((Character)v).charValue()));
        map.put(Double.class, v -> new BsonDouble(((Double)v).doubleValue()));
        map.put(Float.class, v -> new BsonDouble((double)((Float)v).floatValue()));
        map.put(Integer.class, v -> new BsonInt32(((Integer)v).intValue()));
        map.put(Long.class, v -> new BsonInt64(((Long)v).longValue()));
        map.put(Short.class, v -> new BsonInt32((int)((Short)v).shortValue()));
        map.put(String.class, v -> new BsonString((String)v));
        map.put(Class.class, v -> new BsonString(((Class)v).getName()));
        map.put(UUID.class, v -> new BsonString(((UUID)v).toString()));
        map.put(BigDecimal.class, v -> new BsonDecimal128(new Decimal128((BigDecimal)v)));
        map.put(BigInteger.class, v -> new BsonDecimal128(new Decimal128(new BigDecimal((BigInteger)v))));
        map.put(Date.class, v -> new BsonDateTime(((Date)v).getTime()));
        map.put(LocalDate.class, v -> new BsonString(EzyDates.format((TemporalAccessor)((LocalDate)v), (String)"yyyy-MM-dd")));
        map.put(LocalDateTime.class, v -> new BsonString(EzyDates.format((TemporalAccessor)((LocalDateTime)v))));
        map.put(boolean[].class, v -> {
            BsonArray array = new BsonArray();
            for (boolean value : (boolean[])v) {
                array.add((BsonValue)new BsonBoolean(value));
            }
            return array;
        });
        map.put(byte[].class, v -> new BsonBinary((byte[])v));
        map.put(char[].class, v -> new BsonString(new String((char[])v)));
        map.put(double[].class, v -> {
            BsonArray array = new BsonArray();
            for (double value : (double[])v) {
                array.add((BsonValue)new BsonDouble(value));
            }
            return array;
        });
        map.put(float[].class, v -> {
            BsonArray array = new BsonArray();
            for (float value : (float[])v) {
                array.add((BsonValue)new BsonDouble((double)value));
            }
            return array;
        });
        map.put(int[].class, v -> {
            BsonArray array = new BsonArray();
            for (int value : (int[])v) {
                array.add((BsonValue)new BsonInt32(value));
            }
            return array;
        });
        map.put(long[].class, v -> {
            BsonArray array = new BsonArray();
            for (long value : (long[])v) {
                array.add((BsonValue)new BsonInt64(value));
            }
            return array;
        });
        map.put(short[].class, v -> {
            BsonArray array = new BsonArray();
            for (short value : (short[])v) {
                array.add((BsonValue)new BsonInt32((int)value));
            }
            return array;
        });
        return map;
    }
}

