/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb.repository;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import com.tvd12.ezydata.database.repository.EzyMaxIdRepository;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

public class EzyMongoMaxIdRepository
implements EzyMaxIdRepository {
    protected final MongoCollection<Document> collection;

    public EzyMongoMaxIdRepository(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    public Long incrementAndGet(String key) {
        return this.incrementAndGet(key, 1);
    }

    public Long incrementAndGet(String key, int delta) {
        BsonDocument filter = new BsonDocument();
        BsonString bsonId = new BsonString(key);
        filter.put("_id", (BsonValue)bsonId);
        BsonDocument updateValue = new BsonDocument();
        updateValue.put("value", (BsonValue)new BsonInt32(delta));
        BsonDocument update = new BsonDocument();
        update.put("$inc", (BsonValue)updateValue);
        FindOneAndUpdateOptions opts = new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER);
        Document result = (Document)this.collection.findOneAndUpdate((Bson)filter, (Bson)update, opts);
        Object value = result != null ? result.get((Object)"value") : null;
        return value != null ? ((Number)value).longValue() : 0L;
    }
}

