/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb.repository;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.database.EzyDatabaseContextAware;
import com.tvd12.ezydata.database.query.EzyQLQuery;
import com.tvd12.ezydata.mongodb.EzyMongoCollectionAware;
import com.tvd12.ezydata.mongodb.EzyMongoDatabaseContext;
import com.tvd12.ezydata.mongodb.EzyMongoRepository;
import com.tvd12.ezydata.mongodb.util.BsonDocuments;
import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.database.util.EzyCollectionAnnotations;
import com.tvd12.ezyfox.exception.UnimplementedOperationException;
import com.tvd12.ezyfox.naming.EzyNameTranslator;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyObjectProxy;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.Next;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class EzySimpleMongoRepository<I, E>
extends EzyLoggable
implements EzyMongoRepository<I, E>,
EzyDatabaseContextAware,
EzyMongoCollectionAware {
    protected final Class<E> entityType;
    protected Class<I> idType = this.getIdType();
    protected String collectionName;
    protected EzyObjectProxy objectProxy;
    protected MongoCollection<BsonDocument> collection;
    protected EzyMongoDatabaseContext databaseContext;
    protected EzyNameTranslator collectionNameTranslator;

    public EzySimpleMongoRepository() {
        this.entityType = this.getEntityType();
        this.collectionName = EzyCollectionAnnotations.getCollectionName(this.entityType);
    }

    public void setDatabaseContext(EzyDatabaseContext databaseContext) {
        this.databaseContext = (EzyMongoDatabaseContext)databaseContext;
        this.collectionNameTranslator = this.databaseContext.getCollectionNameTranslator();
        this.collectionName = this.collectionNameTranslator.translate(this.collectionName);
        this.objectProxy = this.databaseContext.getObjectProxy(this.entityType);
        this.idType = this.objectProxy.getPropertyType("_id");
        this.setCollection(this.databaseContext.getCollection(this.collectionName, BsonDocument.class));
    }

    @Override
    public void setCollection(MongoCollection collection) {
        this.collection = collection;
    }

    public long count() {
        return this.collection.countDocuments();
    }

    public void save(E entity) {
        BsonDocument document = this.entityToBsonDocument(entity);
        BsonValue id = document.get((Object)"_id");
        if (id == BsonNull.VALUE) {
            document.remove((Object)"_id");
            this.collection.insertOne((Object)document);
            BsonValue resultId = document.get((Object)"_id");
            I idValue = this.bsonValueToData(resultId, this.idType);
            this.objectProxy.setProperty(entity, "_id", idValue);
        } else {
            BsonDocument filter = new BsonDocument("_id", id);
            ReplaceOptions opts = new ReplaceOptions().upsert(true);
            this.collection.replaceOne((Bson)filter, (Object)document, opts);
        }
    }

    public void save(Iterable<E> entities) {
        List entityList = this.iterableToList(entities);
        if (entityList.isEmpty()) {
            return;
        }
        ArrayList<Object> request = new ArrayList<Object>();
        for (Object entity : entityList) {
            BsonDocument document = this.entityToBsonDocument(entity);
            BsonValue id = document.get((Object)"_id");
            if (id == BsonNull.VALUE) {
                document.remove((Object)"_id");
                request.add(new InsertOneModel((Object)document));
                continue;
            }
            BsonDocument filter = new BsonDocument("_id", id);
            ReplaceOptions opts = new ReplaceOptions().upsert(true);
            request.add(new ReplaceOneModel((Bson)filter, (Object)document, opts));
        }
        this.collection.bulkWrite(request);
        for (int i = 0; i < request.size(); ++i) {
            WriteModel model = (WriteModel)request.get(i);
            if (!(model instanceof InsertOneModel)) continue;
            InsertOneModel m = (InsertOneModel)model;
            BsonDocument document = (BsonDocument)m.getDocument();
            I idValue = this.bsonValueToData(document.get((Object)"_id"), this.idType);
            this.objectProxy.setProperty(entityList.get(i), "_id", idValue);
        }
    }

    public E findById(I id) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(id);
        filter.put("_id", bsonId);
        FindIterable list = this.collection.find((Bson)filter).limit(1);
        return this.bsonDocumentToEntity((BsonDocument)list.first());
    }

    public List<E> findListByIds(Collection<I> ids) {
        BsonDocument filter = new BsonDocument();
        BsonArray bsonIds = new BsonArray();
        for (I id : ids) {
            bsonIds.add(this.dataToBsonValue(id));
        }
        filter.put("_id", (BsonValue)new BsonDocument("$in", (BsonValue)bsonIds));
        FindIterable list = this.collection.find((Bson)filter);
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument document : list) {
            entities.add(this.bsonDocumentToEntity(document));
        }
        return entities;
    }

    public E findByField(String field, Object value) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(value);
        filter.put(field, bsonId);
        FindIterable list = this.collection.find((Bson)filter).limit(1);
        return this.bsonDocumentToEntity((BsonDocument)list.first());
    }

    public List<E> findListByField(String field, Object value) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(value);
        filter.put(field, bsonId);
        FindIterable list = this.collection.find((Bson)filter);
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument document : list) {
            entities.add(this.bsonDocumentToEntity(document));
        }
        return entities;
    }

    public List<E> findListByField(String field, Object value, int skip, int limit) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(value);
        filter.put(field, bsonId);
        FindIterable list = this.collection.find((Bson)filter).skip(skip).limit(limit);
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument document : list) {
            entities.add(this.bsonDocumentToEntity(document));
        }
        return entities;
    }

    public List<E> findAll() {
        FindIterable list = this.collection.find();
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument document : list) {
            entities.add(this.bsonDocumentToEntity(document));
        }
        return entities;
    }

    public List<E> findAll(int skip, int limit) {
        FindIterable list = this.collection.find().skip(skip).limit(limit);
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument document : list) {
            entities.add(this.bsonDocumentToEntity(document));
        }
        return entities;
    }

    public int deleteAll() {
        BsonDocument filter = new BsonDocument();
        DeleteResult result = this.collection.deleteMany((Bson)filter);
        return (int)result.getDeletedCount();
    }

    public void delete(I id) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(id);
        filter.put("_id", bsonId);
        this.collection.deleteMany((Bson)filter);
    }

    public boolean containsById(I id) {
        return this.containsByField("_id", id);
    }

    public boolean containsByField(String field, Object value) {
        BsonDocument filter = new BsonDocument();
        Object bsonId = this.dataToBsonValue(value);
        filter.put(field, bsonId);
        FindIterable list = this.collection.find((Bson)filter).limit(1);
        return list.first() != null;
    }

    public int deleteByIds(Collection<I> ids) {
        BsonDocument filter = new BsonDocument();
        BsonArray bsonIds = new BsonArray();
        for (I id : ids) {
            bsonIds.add(this.dataToBsonValue(id));
        }
        filter.put("_id", (BsonValue)new BsonDocument("$in", (BsonValue)bsonIds));
        DeleteResult result = this.collection.deleteMany((Bson)filter);
        return (int)result.getDeletedCount();
    }

    protected E findOneWithQuery(EzyQLQuery query) {
        BsonDocument queryDocument;
        String queryString = query.getValue();
        this.logger.debug("find one with query: {}", (Object)queryString);
        BsonDocument filter = queryDocument = BsonDocument.parse((String)queryString);
        if (queryDocument.containsKey((Object)"$query")) {
            filter = queryDocument.getDocument((Object)"$query");
        }
        FindIterable find = this.collection.find((Bson)filter).limit(1);
        this.decorateToAddProjection((FindIterable<BsonDocument>)find, queryDocument);
        return this.bsonDocumentToEntity((BsonDocument)find.first());
    }

    protected List<E> findListWithQuery(EzyQLQuery query) {
        return this.findListWithQuery(query, null);
    }

    protected List<E> findListWithQuery(EzyQLQuery query, Next next) {
        BsonDocument queryDocument;
        String queryString = query.getValue();
        this.logger.debug("find list with query: {}", (Object)queryString);
        BsonDocument filter = queryDocument = BsonDocument.parse((String)queryString);
        if (queryDocument.containsKey((Object)"$query")) {
            filter = queryDocument.getDocument((Object)"$query");
        }
        FindIterable find = this.collection.find((Bson)filter);
        this.decorateToAddProjection((FindIterable<BsonDocument>)find, queryDocument);
        if (queryDocument.containsKey((Object)"$orderby")) {
            find.sort((Bson)queryDocument.getDocument((Object)"$orderby"));
        } else if (queryDocument.containsKey((Object)"$orderBy")) {
            find.sort((Bson)queryDocument.getDocument((Object)"$orderBy"));
        }
        if (next != null) {
            find.skip((int)next.getSkip());
            find.limit((int)next.getLimit());
        }
        ArrayList<E> entities = new ArrayList<E>();
        for (BsonDocument item : find) {
            E entity = this.bsonDocumentToEntity(item);
            entities.add(entity);
        }
        return entities;
    }

    protected long countWithQuery(EzyQLQuery query) {
        return this.countWithQuery(query, null);
    }

    protected long countWithQuery(EzyQLQuery query, Next next) {
        BsonDocument queryDocument;
        String queryString = query.getValue();
        this.logger.debug("count with query: {}", (Object)queryString);
        BsonDocument filter = queryDocument = BsonDocument.parse((String)queryString);
        CountOptions opts = new CountOptions();
        if (queryDocument.containsKey((Object)"$query")) {
            filter = queryDocument.getDocument((Object)"$query");
        }
        if (next != null) {
            opts.skip((int)next.getSkip());
            opts.limit((int)next.getLimit());
        }
        return this.collection.countDocuments((Bson)filter, opts);
    }

    protected <R> R aggregateOneWithQuery(EzyQLQuery query, Class<R> resultType) {
        List<R> resultList = this.aggregateListWithQuery(query, resultType, Next.limit((long)1L));
        return resultList.isEmpty() ? null : (R)resultList.get(0);
    }

    protected <R> List<R> aggregateListWithQuery(EzyQLQuery query, Class<R> resultType) {
        return this.aggregateListWithQuery(query, resultType, null);
    }

    protected <R> List<R> aggregateListWithQuery(EzyQLQuery query, Class<R> resultType, Next next) {
        String queryString = query.getValue();
        this.logger.debug("fetch list with query: {}", (Object)queryString);
        BsonArray pipeline = BsonArray.parse((String)queryString);
        if (next != null) {
            pipeline.add(new BsonDocument("$skip", (BsonValue)new BsonInt32((int)next.getSkip())));
            pipeline.add(new BsonDocument("$limit", (BsonValue)new BsonInt32((int)next.getLimit())));
        }
        AggregateIterable aggregate = this.collection.aggregate((List)pipeline);
        ArrayList<R> answer = new ArrayList<R>();
        for (BsonDocument item : aggregate) {
            BsonDocuments.decorateIdValue(item);
            answer.add(this.bsonValueToData((BsonValue)item, resultType));
        }
        return answer;
    }

    protected int updateWithQuery(EzyQLQuery query) {
        BsonDocument queryDocument;
        String queryString = query.getValue();
        this.logger.debug("update with query: {}", (Object)queryString);
        BsonDocument filter = queryDocument = BsonDocument.parse((String)queryString);
        if (queryDocument.containsKey((Object)"$query")) {
            filter = queryDocument.getDocument((Object)"$query");
        }
        BsonValue update = null;
        if (queryDocument.containsKey((Object)"$update")) {
            update = queryDocument.get((Object)"$update");
        }
        if (update == null) {
            throw new IllegalArgumentException("missing $update information");
        }
        UpdateResult result = this.collection.updateMany((Bson)filter, (Bson)update);
        return (int)result.getModifiedCount();
    }

    protected int deleteWithQuery(EzyQLQuery query) {
        BsonDocument queryDocument;
        String queryString = query.getValue();
        this.logger.debug("delete with query: {}", (Object)queryString);
        BsonDocument filter = queryDocument = BsonDocument.parse((String)queryString);
        if (queryDocument.containsKey((Object)"$query")) {
            filter = queryDocument.getDocument((Object)"$query");
        }
        DeleteResult result = this.collection.deleteMany((Bson)filter);
        return (int)result.getDeletedCount();
    }

    protected EzyQLQuery.Builder newQueryBuilder() {
        return this.databaseContext.newQueryBuilder();
    }

    protected <T extends BsonValue> T dataToBsonValue(Object data) {
        return this.databaseContext.dataToBsonValue(data);
    }

    protected <T> T bsonValueToData(BsonValue value, Class<T> dataType) {
        return this.databaseContext.bsonValueToData(value, dataType);
    }

    protected BsonDocument entityToBsonDocument(Object entity) {
        BsonDocument document = (BsonDocument)this.dataToBsonValue(entity);
        String idProperty = this.objectProxy.getPropertyName("_id");
        BsonValue idValue = document.get((Object)idProperty);
        BsonDocuments.putIfNotNull(document, "_id", idValue);
        if (!idProperty.equals("_id")) {
            document.remove((Object)idProperty);
        }
        return document;
    }

    protected E bsonDocumentToEntity(BsonDocument document) {
        E entity = this.databaseContext.bsonValueToData((BsonValue)document, this.entityType);
        if (entity == null) {
            return null;
        }
        BsonValue documentId = document.get((Object)"_id");
        I idValue = this.bsonValueToData(documentId, this.idType);
        this.objectProxy.setProperty(entity, "_id", idValue);
        return entity;
    }

    private List iterableToList(Iterable<E> iterable) {
        return Lists.tryNewArrayList(iterable);
    }

    private void decorateToAddProjection(FindIterable<BsonDocument> find, BsonDocument queryDocument) {
        if (queryDocument.containsKey((Object)"$fields")) {
            BsonArray fields = queryDocument.getArray((Object)"$fields");
            find.projection(Projections.include(fields.stream().map(it -> ((BsonString)it).getValue()).collect(Collectors.toList())));
        }
    }

    protected Class getIdType() {
        try {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            Class[] genericArgs = EzyGenerics.getTwoGenericClassArguments((Type)genericSuperclass);
            return genericArgs[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class getEntityType() {
        try {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            Class[] genericArgs = EzyGenerics.getTwoGenericClassArguments((Type)genericSuperclass);
            return genericArgs[1];
        }
        catch (Exception e) {
            throw new UnimplementedOperationException("class " + this.getClass().getName() + " hasn't implemented method 'getEntityType'", (Throwable)e);
        }
    }
}

