/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.serializers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.tvd12.reflections.Reflections;
import com.tvd12.reflections.io.Files;
import com.tvd12.reflections.serializers.Serializer;
import com.tvd12.reflections.util.Multimap;
import com.tvd12.reflections.util.Multimaps;
import com.tvd12.reflections.util.SetMultimap;
import com.tvd12.reflections.util.Sets;
import com.tvd12.reflections.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class JsonSerializer
implements Serializer {
    private Gson gson;

    @Override
    public Reflections read(InputStream inputStream) {
        return (Reflections)this.getGson().fromJson((Reader)new InputStreamReader(inputStream), Reflections.class);
    }

    @Override
    public File save(Reflections reflections, String filename) {
        try {
            File file = Utils.prepareFile(filename);
            Files.write(this.toString(reflections), file, Charset.defaultCharset());
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString(Reflections reflections) {
        return this.getGson().toJson((Object)reflections);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Multimap.class, (Object)new com.google.gson.JsonSerializer<Multimap>(){

                public JsonElement serialize(Multimap multimap, Type type, JsonSerializationContext jsonSerializationContext) {
                    return jsonSerializationContext.serialize(multimap.asMap());
                }
            }).registerTypeAdapter(Multimap.class, (Object)new JsonDeserializer<Multimap>(){

                public Multimap deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    SetMultimap map = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<String>>(){

                        @Override
                        public Set<String> get() {
                            return Sets.newHashSet(new String[0]);
                        }
                    });
                    for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                        for (JsonElement element : (JsonArray)entry.getValue()) {
                            map.get(entry.getKey()).add(element.getAsString());
                        }
                    }
                    return map;
                }
            }).setPrettyPrinting().create();
        }
        return this.gson;
    }
}

