/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis;

import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezyfox.builder.EzyBuilder;

public class EzyRedisAtomicLong {
    protected final String name;
    protected final String mapName;
    protected final byte[] nameBytes;
    protected final byte[] mapNameBytes;
    protected final EzyRedisClient redisClient;

    protected EzyRedisAtomicLong(Builder builder) {
        this.name = builder.name;
        this.mapName = builder.mapName;
        this.nameBytes = this.name.getBytes();
        this.mapNameBytes = this.mapName.getBytes();
        this.redisClient = builder.redisClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long get() {
        return this.redisClient.hincrBy(this.mapNameBytes, this.nameBytes, 0L);
    }

    public long addAndGet(long delta) {
        return this.redisClient.hincrBy(this.mapNameBytes, this.nameBytes, delta);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    implements EzyBuilder<EzyRedisAtomicLong> {
        protected String name;
        protected String mapName;
        protected EzyRedisClient redisClient;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public Builder redisClient(EzyRedisClient redisClient) {
            this.redisClient = redisClient;
            return this;
        }

        public EzyRedisAtomicLong build() {
            return new EzyRedisAtomicLong(this);
        }
    }
}

