/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis;

import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezydata.redis.EzyRedisSubscriber;
import com.tvd12.ezydata.redis.concurrent.EzyRedisThreadFactory;
import com.tvd12.ezydata.redis.setting.EzyRedisChannelSetting;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyEntityCodec;
import com.tvd12.ezyfox.concurrent.EzyThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

public class EzyRedisChannel<T> {
    protected final String channelName;
    protected final byte[] channelNameBytes;
    protected final Class messageType;
    protected final EzyRedisClient redisClient;
    protected final EzyEntityCodec entityCodec;
    protected final EzyRedisChannelSetting setting;
    protected final int subThreadPoolSize;
    protected final String subThreadPoolName;
    protected volatile boolean subscribed;
    protected List<Consumer<T>> subscribers;
    protected ExecutorService subExecutorService;

    public EzyRedisChannel(Builder builder) {
        this.setting = builder.setting;
        this.redisClient = builder.redisClient;
        this.entityCodec = builder.entityCodec;
        this.channelName = builder.channelName;
        this.messageType = this.setting.getMessageType();
        this.channelNameBytes = this.channelName.getBytes();
        this.subThreadPoolSize = this.setting.getSubThreadPoolSize();
        this.subThreadPoolName = "channel-subscriber-" + this.channelName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Long publish(T message) {
        byte[] messageBytes = this.entityCodec.serialize(message);
        return this.redisClient.publish(this.channelNameBytes, messageBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Consumer<T> subscriber) {
        EzyRedisChannel ezyRedisChannel = this;
        synchronized (ezyRedisChannel) {
            if (!this.subscribed) {
                this.subscribed = true;
                this.subExecutorService = this.newSubExecutorService();
                this.subscribers = Collections.synchronizedList(new ArrayList());
                this.subscribe();
            }
        }
        this.subscribers.add(subscriber);
    }

    protected ExecutorService newSubExecutorService() {
        EzyThreadFactory threadFactory = EzyRedisThreadFactory.create(this.subThreadPoolName);
        ExecutorService executorService = Executors.newFixedThreadPool(this.subThreadPoolSize, (ThreadFactory)threadFactory);
        Runtime.getRuntime().addShutdownHook(new Thread(executorService::shutdown));
        return executorService;
    }

    protected void subscribe() {
        EzyRedisSubscriber subscriber = (channel, messageBytes) -> {
            Object message = this.entityCodec.deserialize(messageBytes, this.messageType);
            for (Consumer<Object> consumer : this.subscribers) {
                consumer.accept(message);
            }
        };
        for (int i = 0; i < this.subThreadPoolSize; ++i) {
            this.subExecutorService.execute(() -> this.redisClient.subscribe(this.channelNameBytes, subscriber));
        }
    }

    public static class Builder
    implements EzyBuilder<EzyRedisChannel> {
        protected String channelName;
        protected EzyRedisClient redisClient;
        protected EzyEntityCodec entityCodec;
        protected EzyRedisChannelSetting setting;

        public Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public Builder redisClient(EzyRedisClient redisClient) {
            this.redisClient = redisClient;
            return this;
        }

        public Builder entityCodec(EzyEntityCodec entityCodec) {
            this.entityCodec = entityCodec;
            return this;
        }

        public Builder setting(EzyRedisChannelSetting setting) {
            this.setting = setting;
            return this;
        }

        public EzyRedisChannel build() {
            return new EzyRedisChannel(this);
        }
    }
}

