/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis;

import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezydata.redis.setting.EzyRedisMapSetting;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyEntityCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EzyRedisMap<K, V>
implements Map<K, V> {
    protected final String mapName;
    protected final byte[] mapNameBytes;
    protected final Class<K> keyType;
    protected final Class<V> valueType;
    protected final EzyRedisClient redisClient;
    protected final EzyEntityCodec entityCodec;
    protected final EzyRedisMapSetting setting;

    protected EzyRedisMap(Builder builder) {
        this.setting = builder.setting;
        this.mapName = builder.mapName;
        this.keyType = this.setting.getKeyType();
        this.valueType = this.setting.getValueType();
        this.redisClient = builder.redisClient;
        this.entityCodec = builder.entityCodec;
        this.mapNameBytes = this.mapName.getBytes();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public V put(K key, V value) {
        byte[] keyBytes = this.entityCodec.serialize(key);
        byte[] valueBytes = this.entityCodec.serialize(value);
        this.redisClient.hset(this.mapNameBytes, keyBytes, valueBytes);
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<byte[], byte[]> keyValueBytesMap = new HashMap<byte[], byte[]>();
        for (K key : m.keySet()) {
            V value = m.get(key);
            byte[] keyBytes = this.entityCodec.serialize(key);
            byte[] valueBytes = this.entityCodec.serialize(value);
            keyValueBytesMap.put(keyBytes, valueBytes);
        }
        this.redisClient.hmset(this.mapNameBytes, keyValueBytesMap);
    }

    @Override
    public V get(Object key) {
        byte[] keyBytes = this.entityCodec.serialize(key);
        byte[] valueBytes = this.redisClient.hget(this.mapNameBytes, keyBytes);
        if (valueBytes == null) {
            return null;
        }
        return (V)this.entityCodec.deserialize(valueBytes, this.valueType);
    }

    public Map<K, V> get(Set<K> keys) {
        byte[][] keyBytesArray = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            keyBytesArray[i++] = this.entityCodec.serialize(key);
        }
        List<byte[]> valueBytesList = this.redisClient.hmget(this.mapNameBytes, keyBytesArray);
        HashMap<K, Object> answer = new HashMap<K, Object>();
        int k = 0;
        for (K key : keys) {
            byte[] valueBytes;
            if ((valueBytes = valueBytesList.get(k++)) == null) continue;
            Object value = this.entityCodec.deserialize(valueBytes, this.valueType);
            answer.put(key, value);
        }
        return answer;
    }

    @Override
    public boolean containsKey(Object key) {
        byte[] keyBytes = this.entityCodec.serialize(key);
        byte[] valueBytes = this.redisClient.hget(this.mapNameBytes, keyBytes);
        return valueBytes != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Map<byte[], byte[]> keyValueBytesMap = this.redisClient.hgetAll(this.mapNameBytes);
        for (byte[] valueBytes : keyValueBytesMap.values()) {
            Object v = this.entityCodec.deserialize(valueBytes, this.valueType);
            if (!value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        byte[] keyBytes = this.entityCodec.serialize(key);
        this.redisClient.hdel(this.mapNameBytes, keyBytes);
        return null;
    }

    public int remove(Collection<K> keys) {
        byte[][] keyBytesArray = new byte[keys.size()][];
        int i = 0;
        for (K key : keys) {
            keyBytesArray[i++] = this.entityCodec.serialize(key);
        }
        Long count = this.redisClient.hdel(this.mapNameBytes, keyBytesArray);
        return count.intValue();
    }

    @Override
    public Set<K> keySet() {
        Set<byte[]> keyBytesSet = this.redisClient.hkeys(this.mapNameBytes);
        HashSet<Object> answer = new HashSet<Object>();
        for (byte[] keyBytes : keyBytesSet) {
            Object key = this.entityCodec.deserialize(keyBytes, this.keyType);
            answer.add(key);
        }
        return answer;
    }

    @Override
    public Collection<V> values() {
        Map<byte[], byte[]> keyValueBytesMap = this.redisClient.hgetAll(this.mapNameBytes);
        ArrayList<Object> answer = new ArrayList<Object>();
        for (byte[] valueBytes : keyValueBytesMap.values()) {
            Object value = this.entityCodec.deserialize(valueBytes, this.valueType);
            answer.add(value);
        }
        return answer;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<byte[], byte[]> keyValueBytesMap = this.redisClient.hgetAll(this.mapNameBytes);
        HashMap<Object, Object> answer = new HashMap<Object, Object>();
        for (byte[] keyBytes : keyValueBytesMap.keySet()) {
            byte[] valueBytes = keyValueBytesMap.get(keyBytes);
            Object key = this.entityCodec.deserialize(keyBytes, this.keyType);
            Object value = this.entityCodec.deserialize(valueBytes, this.valueType);
            answer.put(key, value);
        }
        return answer.entrySet();
    }

    @Override
    public int size() {
        return (int)this.sizeLong();
    }

    public long sizeLong() {
        return this.redisClient.hlen(this.mapNameBytes);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.redisClient.del(this.mapNameBytes);
    }

    public String getName() {
        return this.mapName;
    }

    public static class Builder
    implements EzyBuilder<EzyRedisMap> {
        protected String mapName;
        protected EzyRedisClient redisClient;
        protected EzyEntityCodec entityCodec;
        protected EzyRedisMapSetting setting;

        public Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public Builder setting(EzyRedisMapSetting setting) {
            this.setting = setting;
            return this;
        }

        public Builder redisClient(EzyRedisClient redisClient) {
            this.redisClient = redisClient;
            return this;
        }

        public Builder entityCodec(EzyEntityCodec entityCodec) {
            this.entityCodec = entityCodec;
            return this;
        }

        public EzyRedisMap build() {
            return new EzyRedisMap(this);
        }
    }
}

