/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis;

import com.tvd12.ezydata.redis.EzyRedisAtomicLong;
import com.tvd12.ezydata.redis.EzyRedisChannel;
import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezydata.redis.EzyRedisMap;
import com.tvd12.ezydata.redis.factory.EzyRedisAtomicLongFactory;
import com.tvd12.ezydata.redis.factory.EzyRedisChannelFactory;
import com.tvd12.ezydata.redis.factory.EzyRedisMapFactory;
import com.tvd12.ezydata.redis.manager.EzyRedisAtomicLongProvider;
import com.tvd12.ezydata.redis.manager.EzyRedisChannelProvider;
import com.tvd12.ezydata.redis.manager.EzyRedisMapProvider;
import com.tvd12.ezydata.redis.setting.EzyRedisSettings;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyEntityCodec;

public class EzyRedisProxy {
    protected final EzyRedisSettings settings;
    protected final EzyRedisClient redisClient;
    protected final EzyEntityCodec entityCodec;
    protected final EzyRedisMapFactory mapFactory;
    protected final EzyRedisMapProvider mapProvider;
    protected final EzyRedisChannelFactory channelFactory;
    protected final EzyRedisChannelProvider channelProvider;
    protected final EzyRedisAtomicLongFactory atomicLongFactory;
    protected final EzyRedisAtomicLongProvider atomicLongProvider;

    protected EzyRedisProxy(Builder builder) {
        this.settings = builder.settings;
        this.redisClient = builder.redisClient;
        this.entityCodec = builder.entityCodec;
        this.mapFactory = this.newMapFactory();
        this.mapProvider = this.newMapProvider();
        this.channelFactory = this.newChannelFactory();
        this.channelProvider = this.newChannelProvider();
        this.atomicLongFactory = this.newAtomicLongFactory();
        this.atomicLongProvider = this.newAtomicLongProvider();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected EzyRedisMapFactory newMapFactory() {
        return EzyRedisMapFactory.builder().settings(this.settings).redisClient(this.redisClient).entityCodec(this.entityCodec).build();
    }

    protected EzyRedisMapProvider newMapProvider() {
        return EzyRedisMapProvider.builder().mapFactory(this.mapFactory).build();
    }

    protected EzyRedisChannelFactory newChannelFactory() {
        return EzyRedisChannelFactory.builder().settings(this.settings).redisClient(this.redisClient).entityCodec(this.entityCodec).build();
    }

    protected EzyRedisChannelProvider newChannelProvider() {
        return EzyRedisChannelProvider.builder().channelFactory(this.channelFactory).build();
    }

    protected EzyRedisAtomicLongFactory newAtomicLongFactory() {
        return EzyRedisAtomicLongFactory.builder().settings(this.settings).redisClient(this.redisClient).build();
    }

    protected EzyRedisAtomicLongProvider newAtomicLongProvider() {
        return EzyRedisAtomicLongProvider.builder().atomicLongFactory(this.atomicLongFactory).build();
    }

    public <K, V> EzyRedisMap<K, V> getMap(String name) {
        return this.mapProvider.getMap(name);
    }

    public <K, V> EzyRedisMap<K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return this.mapProvider.getMap(name, keyType, valueType);
    }

    public <T> EzyRedisChannel<T> getChannel(String name) {
        return this.channelProvider.getChannel(name);
    }

    public <T> EzyRedisChannel<T> getChannel(String name, Class<T> messageType) {
        return this.channelProvider.getChannel(name, messageType);
    }

    public EzyRedisAtomicLong getAtomicLong(String name) {
        return this.atomicLongProvider.getAtomicLong(name);
    }

    public static class Builder
    implements EzyBuilder<EzyRedisProxy> {
        protected EzyRedisSettings settings;
        protected EzyRedisClient redisClient;
        protected EzyEntityCodec entityCodec;

        public Builder settings(EzyRedisSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder redisClient(EzyRedisClient redisClient) {
            this.redisClient = redisClient;
            return this;
        }

        public Builder entityCodec(EzyEntityCodec entityCodec) {
            this.entityCodec = entityCodec;
            return this;
        }

        public EzyRedisProxy build() {
            return new EzyRedisProxy(this);
        }
    }
}

