/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis;

import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezydata.redis.EzyRedisClientPool;
import com.tvd12.ezydata.redis.EzyRedisProxy;
import com.tvd12.ezydata.redis.annotation.EzyRedisMessage;
import com.tvd12.ezydata.redis.loader.EzyJedisClientPoolLoader;
import com.tvd12.ezydata.redis.setting.EzyRedisSettings;
import com.tvd12.ezydata.redis.setting.EzyRedisSettingsBuilder;
import com.tvd12.ezydata.redis.util.EzyRedisMessageAnnotations;
import com.tvd12.ezyfox.annotation.EzyId;
import com.tvd12.ezyfox.binding.EzyBindingContext;
import com.tvd12.ezyfox.binding.EzyBindingContextBuilder;
import com.tvd12.ezyfox.binding.codec.EzyBindingEntityCodec;
import com.tvd12.ezyfox.binding.impl.EzySimpleBindingContext;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.codec.EzyEntityCodec;
import com.tvd12.ezyfox.codec.EzyMessageDeserializer;
import com.tvd12.ezyfox.codec.EzyMessageSerializer;
import com.tvd12.ezyfox.codec.MsgPackSimpleDeserializer;
import com.tvd12.ezyfox.codec.MsgPackSimpleSerializer;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.data.annotation.EzyCachedKey;
import com.tvd12.ezyfox.data.annotation.EzyCachedValue;
import com.tvd12.ezyfox.data.util.EzyCachedValueAnnotations;
import com.tvd12.ezyfox.message.annotation.EzyMessage;
import com.tvd12.ezyfox.naming.EzyNameTranslator;
import com.tvd12.ezyfox.naming.EzyNamingCase;
import com.tvd12.ezyfox.naming.EzySimpleNameTranslator;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyThreads;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Id;

public class EzyRedisProxyFactory
extends EzyLoggable {
    protected final EzyRedisSettings settings;
    protected final EzyEntityCodec entityCodec;
    protected final EzyRedisClientPool clientPool;
    protected final int maxConnectionAttempts;

    protected EzyRedisProxyFactory(Builder builder) {
        this.settings = builder.settings;
        this.entityCodec = builder.entityCodec;
        this.clientPool = builder.clientPool;
        this.maxConnectionAttempts = builder.maxConnectionAttempts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EzyRedisProxy newRedisProxy() {
        return EzyRedisProxy.builder().settings(this.settings).redisClient(this.getRedisClient()).entityCodec(this.entityCodec).build();
    }

    private EzyRedisClient getRedisClient() {
        int retryCount = 0;
        while (true) {
            try {
                return this.clientPool.getClient();
            }
            catch (Exception e) {
                if (retryCount >= this.maxConnectionAttempts) {
                    throw e;
                }
                this.logger.error("can not get redis client, retry count: {}", (Object)(++retryCount), (Object)e);
                EzyThreads.sleep((long)3000L);
                continue;
            }
            break;
        }
    }

    public static class Builder
    implements EzyBuilder<EzyRedisProxyFactory> {
        protected EzyReflection reflection;
        protected Set<String> packagesToScan;
        protected Properties properties = new Properties();
        protected int maxConnectionAttempts;
        protected EzyRedisSettings settings;
        protected EzyEntityCodec entityCodec;
        protected EzyRedisClientPool clientPool;
        protected EzyRedisSettingsBuilder settingsBuilder;
        protected EzyNameTranslator mapNameTranslator;

        public Builder() {
            this.packagesToScan = new HashSet<String>();
        }

        public Builder scan(String packageName) {
            this.packagesToScan.add(packageName);
            return this;
        }

        public Builder scan(String ... packageNames) {
            return this.scan(Sets.newHashSet((Object[])packageNames));
        }

        public Builder scan(Iterable<String> packageNames) {
            for (String packageName : packageNames) {
                this.scan(packageName);
            }
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder settings(EzyRedisSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder settingsBuilder(EzyRedisSettingsBuilder settingsBuilder) {
            this.settingsBuilder = settingsBuilder;
            return this;
        }

        public Builder entityCodec(EzyEntityCodec entityCodec) {
            this.entityCodec = entityCodec;
            return this;
        }

        public Builder clientPool(EzyRedisClientPool clientPool) {
            this.clientPool = clientPool;
            return this;
        }

        public Builder mapNameTranslator(EzyNameTranslator mapNameTranslator) {
            this.mapNameTranslator = mapNameTranslator;
            return this;
        }

        public Builder mapNameTranslator(EzyNamingCase namingCase, String ignoredSuffix) {
            return this.mapNameTranslator((EzyNameTranslator)EzySimpleNameTranslator.builder().namingCase(namingCase).ignoredSuffix(ignoredSuffix).build());
        }

        public EzyRedisProxyFactory build() {
            if (this.packagesToScan.size() > 0) {
                this.reflection = new EzyReflectionProxy(this.packagesToScan);
            }
            this.extractProperties();
            this.prepareMapNameTranslator();
            this.prepareSettings();
            this.prepareEntityCodec();
            this.prepareClientPool();
            return new EzyRedisProxyFactory(this);
        }

        private void extractProperties() {
            this.maxConnectionAttempts = Integer.parseInt(this.properties.getOrDefault((Object)"redis.max_connection_attempts", (Object)this.maxConnectionAttempts).toString());
        }

        private void prepareSettings() {
            if (this.settings != null) {
                return;
            }
            if (this.settingsBuilder == null) {
                this.settingsBuilder = new EzyRedisSettingsBuilder();
            }
            this.settingsBuilder.properties(this.properties);
            if (this.reflection != null) {
                Set cachedClasses = this.reflection.getAnnotatedClasses(EzyCachedValue.class);
                for (Class cachedClass : cachedClasses) {
                    EzyField keyField = this.getMapKeyFieldOf(cachedClass);
                    String mapName = this.mapNameTranslator.translate(EzyCachedValueAnnotations.getMapName((Class)cachedClass));
                    this.settingsBuilder.mapSettingBuilder(mapName).keyType(keyField.getType()).valueType(cachedClass);
                }
                HashSet messageClasses = new HashSet();
                messageClasses.addAll(this.reflection.getAnnotatedClasses(EzyMessage.class));
                messageClasses.addAll(this.reflection.getAnnotatedClasses(EzyRedisMessage.class));
                for (Class messageClass : messageClasses) {
                    String channelName = EzyRedisMessageAnnotations.getChannelName(messageClass);
                    this.settingsBuilder.channelSettingBuilder(channelName).messageType(messageClass);
                }
            }
            this.settings = this.settingsBuilder.build();
        }

        private void prepareEntityCodec() {
            if (this.entityCodec != null) {
                return;
            }
            EzyBindingContextBuilder bindingContextBuilder = EzyBindingContext.builder();
            if (this.reflection != null) {
                Set valueClasses = this.reflection.getAnnotatedClasses(EzyCachedValue.class);
                bindingContextBuilder.addAllClasses((Object)this.reflection).addClasses((Iterable)valueClasses).addClasses((Iterable)this.reflection.getAnnotatedClasses(EzyMessage.class)).addClasses((Iterable)this.reflection.getAnnotatedClasses(EzyRedisMessage.class)).addClasses((Iterable)this.reflection.getAnnotatedClasses(EzyCachedKey.class));
                for (Class valueClass : valueClasses) {
                    EzyField keyField = this.getMapKeyFieldOf(valueClass);
                    EzyCachedKey cachedKeyAnno = (EzyCachedKey)keyField.getAnnotation(EzyCachedKey.class);
                    if (cachedKeyAnno == null || !cachedKeyAnno.composite()) continue;
                    bindingContextBuilder.addClass(keyField.getType());
                }
            }
            EzySimpleBindingContext bindingContext = bindingContextBuilder.build();
            this.entityCodec = ((EzyBindingEntityCodec.Builder)((EzyBindingEntityCodec.Builder)EzyBindingEntityCodec.builder().marshaller(bindingContext.newMarshaller()).unmarshaller(bindingContext.newUnmarshaller()).messageSerializer((EzyMessageSerializer)new MsgPackSimpleSerializer())).messageDeserializer((EzyMessageDeserializer)new MsgPackSimpleDeserializer())).build();
        }

        private EzyField getMapKeyFieldOf(Class<?> mapValueClass) {
            EzyClass clazz = new EzyClass(mapValueClass);
            return (EzyField)clazz.getField(f -> f.isAnnotated(EzyCachedKey.class) || f.isAnnotated(EzyId.class) || f.isAnnotated(Id.class)).orElseThrow(() -> new IllegalArgumentException("unknown key type of cached value type: " + mapValueClass.getName() + ", annotate key field with @EzyCachedKey or @EzyId or @Id"));
        }

        private void prepareClientPool() {
            if (this.clientPool != null) {
                return;
            }
            this.clientPool = ((EzyJedisClientPoolLoader)new EzyJedisClientPoolLoader().properties(this.properties)).load();
        }

        protected void prepareMapNameTranslator() {
            if (this.mapNameTranslator == null) {
                EzyNamingCase namingCase = EzyNamingCase.of((String)this.properties.getProperty("redis.map_naming.case"));
                String ignoredSuffix = this.properties.getProperty("redis.map_naming.ignored_suffix");
                this.mapNameTranslator(namingCase, ignoredSuffix);
            }
        }
    }
}

