/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.setting;

import com.tvd12.ezydata.redis.setting.EzyRedisChannelSetting;
import com.tvd12.ezydata.redis.setting.EzyRedisChannelSettingBuilder;
import com.tvd12.ezydata.redis.setting.EzyRedisMapSetting;
import com.tvd12.ezydata.redis.setting.EzyRedisMapSettingBuilder;
import com.tvd12.ezydata.redis.setting.EzyRedisSettings;
import com.tvd12.ezydata.redis.setting.EzyRedisSimpleSettings;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.properties.file.util.PropertiesUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class EzyRedisSettingsBuilder
implements EzyBuilder<EzyRedisSettings> {
    protected String atomicLongMapName = "___ezydata.atomic_longs___";
    protected Map<String, EzyRedisMapSetting> mapSettings = new HashMap<String, EzyRedisMapSetting>();
    protected Map<String, EzyRedisChannelSetting> channelSettings;
    protected Map<String, EzyRedisMapSettingBuilder> mapSettingBuilders = new HashMap<String, EzyRedisMapSettingBuilder>();
    protected Map<String, EzyRedisChannelSettingBuilder> channelSettingBuilders;

    public EzyRedisSettingsBuilder() {
        this.channelSettings = new HashMap<String, EzyRedisChannelSetting>();
        this.channelSettingBuilders = new HashMap<String, EzyRedisChannelSettingBuilder>();
    }

    public EzyRedisSettingsBuilder atomicLongMapName(String atomicLongMapName) {
        if (atomicLongMapName != null) {
            this.atomicLongMapName = atomicLongMapName;
        }
        return this;
    }

    public EzyRedisSettingsBuilder addMapSetting(String mapName, EzyRedisMapSetting setting) {
        this.mapSettings.compute(mapName, (k, v) -> {
            if (v == null) {
                return setting;
            }
            return new EzyRedisMapSettingBuilder().keyType(setting.getKeyType()).valueType(setting.getValueType()).build();
        });
        return this;
    }

    public EzyRedisMapSettingBuilder mapSettingBuilder(String mapName) {
        EzyRedisMapSettingBuilder builder = this.mapSettingBuilders.get(mapName);
        if (builder == null) {
            builder = new EzyRedisMapSettingBuilder(this);
            this.mapSettingBuilders.put(mapName, builder);
        }
        return builder;
    }

    public EzyRedisSettingsBuilder addChannelSetting(String channelName, EzyRedisChannelSetting setting) {
        this.channelSettings.compute(channelName, (k, v) -> {
            if (v == null) {
                return setting;
            }
            return new EzyRedisChannelSettingBuilder().messageType(setting.getMessageType()).subThreadPoolSize(setting.getSubThreadPoolSize()).build();
        });
        return this;
    }

    public EzyRedisChannelSettingBuilder channelSettingBuilder(String channelName) {
        EzyRedisChannelSettingBuilder builder = this.channelSettingBuilders.get(channelName);
        if (builder == null) {
            builder = new EzyRedisChannelSettingBuilder(this);
            this.channelSettingBuilders.put(channelName, builder);
        }
        return builder;
    }

    public EzyRedisSettingsBuilder properties(Properties properties) {
        this.atomicLongMapName(properties.getProperty("redis.atomic_long_map_name"));
        Map mapsProperties = PropertiesUtil.getPropertiesMap((Map)PropertiesUtil.getPropertiesByPrefix((Map)properties, (String)"redis.maps"));
        for (String mapName : mapsProperties.keySet()) {
            Properties mapProperties = (Properties)mapsProperties.get(mapName);
            this.mapSettingBuilder(mapName).keyType(mapProperties.getProperty("key_type")).valueType(mapProperties.getProperty("value_type"));
        }
        Map channelsProperties = PropertiesUtil.getPropertiesMap((Map)PropertiesUtil.getPropertiesByPrefix((Map)properties, (String)"redis.channels"));
        for (String channelName : channelsProperties.keySet()) {
            Properties channelProperties = (Properties)channelsProperties.get(channelName);
            this.channelSettingBuilder(channelName).messageType(channelProperties.getProperty("message_type")).subThreadPoolSize(channelProperties.getProperty("thread_pool_size"));
        }
        return this;
    }

    public EzyRedisSettings build() {
        this.buildMapSettings();
        this.buildChannelSettings();
        EzyRedisSimpleSettings settings = new EzyRedisSimpleSettings();
        settings.addMapSettings(this.mapSettings);
        settings.addChannelSettings(this.channelSettings);
        settings.setAtomicLongMapName(this.atomicLongMapName);
        return settings;
    }

    protected void buildMapSettings() {
        for (String mapName : this.mapSettingBuilders.keySet()) {
            this.addMapSetting(mapName, this.mapSettingBuilders.get(mapName).build());
        }
    }

    protected void buildChannelSettings() {
        for (String channelName : this.channelSettingBuilders.keySet()) {
            this.addChannelSetting(channelName, this.channelSettingBuilders.get(channelName).build());
        }
    }
}

