/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.data;

import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class EzyDataClassesFetcher<T>
extends EzyLoggable {
    protected final Set<Class> classes = new HashSet<Class>();
    protected final Set<String> packagesToScan = new HashSet<String>();
    protected final Set<Class<? extends Annotation>> annotationClasses = this.getAnnotationClasses();

    protected EzyDataClassesFetcher() {
    }

    public T scan(String packageName) {
        this.packagesToScan.add(packageName);
        return (T)((Object)this);
    }

    public T scan(String ... packageNames) {
        return this.scan(Arrays.asList(packageNames));
    }

    public T scan(Iterable<String> packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return (T)((Object)this);
    }

    public T addDataClass(Class clazz) {
        this.classes.add(clazz);
        return (T)((Object)this);
    }

    public T addDataClasses(Class ... classes) {
        return this.addDataClasses(Arrays.asList(classes));
    }

    public T addDataClasses(Iterable<Class> classes) {
        for (Class clazz : classes) {
            this.addDataClass(clazz);
        }
        return (T)((Object)this);
    }

    public T addDataClasses(Object reflection) {
        if (reflection instanceof EzyReflection) {
            EzyReflection ref = (EzyReflection)reflection;
            Set annClasses = ref.getAnnotatedClasses(this.annotationClasses);
            this.classes.addAll(annClasses);
        }
        return (T)((Object)this);
    }

    public Set<Class> getDataClasses() {
        this.addAnnotatedClasses();
        return this.classes;
    }

    private void addAnnotatedClasses() {
        if (this.packagesToScan.isEmpty()) {
            return;
        }
        EzyReflectionProxy reflection = new EzyReflectionProxy(this.packagesToScan);
        this.addDataClasses(reflection);
    }

    protected abstract Set<Class<? extends Annotation>> getAnnotationClasses();
}

