/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.identifier;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import com.tvd12.ezyfox.util.EzyHasIdEntity;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

public abstract class EzyIdEncapsulationBuilder<T, B extends EzyIdEncapsulationBuilder<T, B>>
implements EzyBuilder<T> {
    protected final Set<Class> entityClasses;
    protected final Set<String> packagesToScan = new HashSet<String>();
    protected final Set<Class<? extends Annotation>> annotationClasses;

    public EzyIdEncapsulationBuilder() {
        this.entityClasses = new HashSet<Class>();
        this.annotationClasses = this.getAnnotationClasses();
    }

    public B scan(String packageName) {
        this.packagesToScan.add(packageName);
        return (B)this;
    }

    public B scan(String ... packageNames) {
        return this.scan(Sets.newHashSet((Object[])packageNames));
    }

    public B scan(Iterable<String> packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return (B)this;
    }

    public B addClass(Class clazz) {
        if (this.isHasIdClass(clazz) || this.isAnnotatedClass(clazz)) {
            this.entityClasses.add(clazz);
        }
        return (B)this;
    }

    public B addClasses(Class ... classes) {
        return this.addClasses(Sets.newHashSet((Object[])classes));
    }

    public B addClasses(Iterable<Class> classes) {
        for (Class clazz : classes) {
            this.addClass(clazz);
        }
        return (B)this;
    }

    public B addClasses(EzyReflection reflection) {
        Set hasIdClasses = reflection.getExtendsClasses(EzyHasIdEntity.class);
        HashSet annotatedClasses = new HashSet(reflection.getAnnotatedClasses(this.annotationClasses));
        this.entityClasses.addAll(hasIdClasses);
        this.entityClasses.addAll(annotatedClasses);
        return (B)this;
    }

    public T build() {
        this.preBuild();
        return this.newProduct();
    }

    protected abstract T newProduct();

    protected void preBuild() {
        this.scanAllPackages();
        this.parseEntityClasses();
    }

    protected abstract void parseEntityClasses();

    protected void scanAllPackages() {
        if (this.packagesToScan.isEmpty()) {
            return;
        }
        EzyReflectionProxy reflection = new EzyReflectionProxy(this.packagesToScan);
        this.addClasses((EzyReflection)reflection);
    }

    protected boolean isHasIdClass(Class<?> clazz) {
        return EzyHasIdEntity.class.isAssignableFrom(clazz);
    }

    protected boolean isAnnotatedClass(Class<?> clazz) {
        for (Class<? extends Annotation> annClass : this.annotationClasses) {
            if (!clazz.isAnnotationPresent(annClass)) continue;
            return true;
        }
        return false;
    }

    protected Set<Class<? extends Annotation>> getAnnotationClasses() {
        return new HashSet<Class<? extends Annotation>>();
    }
}

