/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.identifier;

import com.tvd12.ezyfox.annotation.EzyId;
import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.identifier.EzyIdFetcher;
import com.tvd12.ezyfox.identifier.EzyIdFetcherImplementer;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.util.EzyHasIdEntity;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;
import lombok.Generated;

public class EzySimpleIdFetcherImplementer
extends EzyLoggable
implements EzyIdFetcherImplementer {
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected static boolean debug = false;
    protected final EzyClass clazz;
    protected final EzyReflectElement idElement;

    public EzySimpleIdFetcherImplementer(Class<?> clazz) {
        this(new EzyClass(clazz));
    }

    public EzySimpleIdFetcherImplementer(EzyClass clazz) {
        this.clazz = clazz;
        this.idElement = this.getIdElement0();
    }

    @Override
    public EzyIdFetcher implement() {
        try {
            return this.doImplement();
        }
        catch (Exception e) {
            throw new IllegalStateException("implement getter of " + this.clazz + " error", e);
        }
    }

    private EzyIdFetcher doImplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyMethod getIdMethod = this.getGetIdMethod();
        String implMethodContent = this.makeGetIdMethodContent(getIdMethod);
        getIdMethod.setDisplayName("getId");
        this.printMethodContent(implMethodContent);
        implClass.setInterfaces(new CtClass[]{pool.get(EzyIdFetcher.class.getName())});
        implClass.addMethod(CtNewMethod.make((String)implMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        return (EzyIdFetcher)EzyClasses.newInstance((Class)answerClass);
    }

    protected String makeGetIdMethodContent(EzyMethod getIdMethod) {
        Class valueType;
        EzyInstruction instruction = new EzyInstruction("\t", "\n").answer();
        EzyInstruction value = new EzyInstruction("", "", false).cast(this.clazz.getClazz(), "arg0").dot();
        if (this.idElement instanceof EzyField) {
            value.append(this.idElement.getName());
            valueType = ((EzyField)this.idElement).getType();
        } else {
            value.function(this.idElement.getName(), new String[0]);
            valueType = ((EzyMethod)this.idElement).getReturnType();
        }
        instruction.valueOf(valueType, value.toString());
        return new EzyFunction(getIdMethod).body().append(instruction).function().toString();
    }

    protected EzyMethod getGetIdMethod() {
        return EzyMethod.builder().clazz(EzyIdFetcher.class).methodName("getId").parameterTypes(new Class[]{Object.class}).build();
    }

    private EzyReflectElement getIdElement0() {
        Optional foundMethod;
        EzyReflectElement element = this.getIdElement();
        if (element != null) {
            return element;
        }
        if (EzyHasIdEntity.class.isAssignableFrom(this.clazz.getClazz())) {
            return this.clazz.getMethod("getId");
        }
        Optional foundField = this.clazz.getField(f -> f.isAnnotated(EzyId.class));
        if (foundField.isPresent()) {
            EzyField field = (EzyField)foundField.get();
            if (field.isPublic()) {
                return field;
            }
            EzyMethod method = this.clazz.getMethod(field.getGetterMethod());
            if (method != null && method.isPublic()) {
                return method;
            }
        }
        if ((foundMethod = this.clazz.getGetterMethod(m -> m.isAnnotated(EzyId.class))).isPresent()) {
            return (EzyReflectElement)foundMethod.get();
        }
        throw new IllegalStateException("use @EzyId to specific 'id' element on " + this.clazz);
    }

    protected EzyReflectElement getIdElement() {
        return null;
    }

    protected String getImplClassName() {
        return this.clazz.getName() + "$EzyIdFetcher$EzyAutoImpl$" + COUNT.incrementAndGet();
    }

    protected void printMethodContent(String methodContent) {
        if (debug) {
            this.logger.debug("getId: method content \n{}", (Object)methodContent);
        }
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzySimpleIdFetcherImplementer.debug = debug;
    }
}

