/*
 * Decompiled with CFR 0.152.
 */
package com.example.hello_world.handler;

import com.example.hello_world.common.Greeting;
import com.example.hello_world.exception.BadWhoRequestException;
import com.example.hello_world.exception.InvalidChatRequestException;
import com.example.hello_world.request.ChatRequest;
import com.example.hello_world.response.ChatResponse;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.core.annotation.EzyDoHandle;
import com.tvd12.ezyfox.core.annotation.EzyRequestController;
import com.tvd12.ezyfox.core.annotation.EzyTryCatch;
import com.tvd12.ezyfox.core.exception.EzyBadRequestException;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyEntityObjects;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyContext;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzyUserSessionEvent;
import com.tvd12.ezyfoxserver.support.command.EzyObjectResponse;
import com.tvd12.ezyfoxserver.support.factory.EzyResponseFactory;

@EzyRequestController
public class ChatRequestController
extends EzyLoggable {
    @EzyAutoBind
    private Greeting greeting;
    @EzyAutoBind
    private EzyResponseFactory responseFactory;

    @EzyDoHandle(value="secureChat")
    public void secureChat(EzyUser user, ChatRequest request) {
        ((EzyObjectResponse)((EzyObjectResponse)((EzyObjectResponse)this.responseFactory.newObjectResponse().encrypted()).command("secureChat")).param((Object)"secure-message", (Object)this.greeting.greet(request.getWho())).user(user)).execute();
    }

    @EzyDoHandle(value="chatAll")
    public void chatAll(EzyAppContext context, EzyUserSessionEvent event, EzyUser user, EzySession session, ChatRequest request) {
        if (EzyStrings.isBlank((String)request.getWho())) {
            throw new InvalidChatRequestException("request is blank");
        }
        ((EzyObjectResponse)((EzyObjectResponse)this.responseFactory.newObjectResponse().command("chatAll")).param((Object)"message", (Object)this.greeting.greet(request.getWho())).users((Iterable)context.getApp().getUserManager().getUserList())).execute();
    }

    @EzyDoHandle(value="chatZone")
    public void chatZone(EzyAppContext context, ChatRequest request) {
        if (EzyStrings.isBlank((String)request.getWho())) {
            throw new InvalidChatRequestException("request is blank");
        }
        ((EzyObjectResponse)((EzyObjectResponse)this.responseFactory.newObjectResponse().command("chatZone")).param((Object)"message", (Object)this.greeting.greet(request.getWho())).users((Iterable)context.getParent().getZone().getUserManager().getUserList())).execute();
    }

    @EzyDoHandle(value="chatToMe")
    public ChatResponse chatToMe(ChatRequest request) {
        if (EzyStrings.isBlank((String)request.getWho())) {
            throw new EzyBadRequestException(400, "badRequest");
        }
        return new ChatResponse(this.greeting.greet(request.getWho()));
    }

    @EzyDoHandle(value="chat1")
    public void chatFirst(EzyContext context, EzyUser user, ChatRequest request) {
        if (EzyStrings.isBlank((String)request.getWho())) {
            throw new IllegalArgumentException("request is blank");
        }
        if (request.getWho().equals("admin")) {
            throw new BadWhoRequestException("you can not greet admin");
        }
        ((EzyObjectResponse)((EzyObjectResponse)this.responseFactory.newObjectResponse().command("chat1")).param((Object)"message", (Object)this.greeting.greet(request.getWho())).user(user)).execute();
    }

    @EzyDoHandle(value="chat2")
    public void chatSecond() {
        this.logger.info("some one call chat");
    }

    @EzyTryCatch(value={BadWhoRequestException.class})
    public void handle(BadWhoRequestException e, EzyUser user, String cmd, Object data) {
        this.logger.error("try catch BadWhoRequestException, cmd: {}, data: {}", new Object[]{cmd, data, e});
        ((EzyObjectResponse)((EzyObjectResponse)((EzyObjectResponse)this.responseFactory.newObjectResponse().command("err")).data((Object)EzyEntityObjects.newObject((Object)"who", (Object)"invalid"))).user(user)).execute();
    }

    public void setGreeting(Greeting greeting) {
        this.greeting = greeting;
    }

    public void setResponseFactory(EzyResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }
}

