/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.nio.socket;

import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.socket.EzyChannel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import lombok.Generated;

public class EzyNioSocketChannel
implements EzyChannel {
    protected final SocketChannel channel;
    protected final SocketAddress serverAddress;
    protected final SocketAddress clientAddress;

    public EzyNioSocketChannel(SocketChannel channel) {
        this.channel = channel;
        this.serverAddress = (SocketAddress)EzyReturner.returnWithException(channel::getLocalAddress);
        this.clientAddress = (SocketAddress)EzyReturner.returnWithException(channel::getRemoteAddress);
    }

    public int write(Object data, boolean binary) throws Exception {
        return this.channel.write((ByteBuffer)data);
    }

    public SocketChannel getConnection() {
        return this.channel;
    }

    public EzyConnectionType getConnectionType() {
        return EzyConnectionType.SOCKET;
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void disconnect() {
        EzyProcessor.processWithLogException(this.channel::finishConnect);
    }

    public void close() {
        EzyProcessor.processWithLogException(this.channel::close);
    }

    @Generated
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Generated
    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    @Generated
    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }
}

