/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.net;

import com.tvd12.ezyhttp.core.net.PathVariables;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class URITree {
    protected String uri;
    protected Map<String, URITree> children;

    public void addURI(String uri) {
        String[] paths;
        URITree lastChild = this;
        for (String s : paths = uri.split("/")) {
            String path;
            if (lastChild.children == null) {
                lastChild.children = new HashMap<String, URITree>();
            }
            if (PathVariables.isPathVariable(path = s)) {
                path = "{}";
            }
            lastChild = lastChild.children.computeIfAbsent(path, k -> new URITree());
        }
        lastChild.uri = uri;
    }

    public String getMatchedURI(String uri) {
        URITree childC;
        String[] paths = uri.split("/");
        LinkedList<TreeItem> queue = new LinkedList<TreeItem>();
        queue.offer(new TreeItem(0, this));
        while (true) {
            URITree childB;
            TreeItem item;
            if ((item = (TreeItem)queue.poll()) == null) {
                return null;
            }
            if (item.index == paths.length) {
                if (((TreeItem)item).child.uri == null) continue;
                return ((TreeItem)item).child.uri;
            }
            if (((TreeItem)item).child.children == null) continue;
            URITree childA = ((TreeItem)item).child.children.get(paths[item.index]);
            if (childA != null) {
                queue.offer(new TreeItem(item.index + 1, childA));
            }
            if ((childB = ((TreeItem)item).child.children.get("{}")) != null) {
                queue.offer(new TreeItem(item.index + 1, childB));
            }
            if ((childC = ((TreeItem)item).child.children.get("*")) != null) break;
        }
        return childC.uri;
    }

    public String toString() {
        if (this.children == null) {
            return this.uri;
        }
        return this.children.toString();
    }

    private static class TreeItem {
        private final int index;
        private final URITree child;

        private TreeItem(int index, URITree child) {
            this.index = index;
            this.child = child;
        }
    }
}

