/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.tvd12.ezydata.database.EzyDatabaseContextBuilder;
import com.tvd12.ezydata.database.EzySimpleDatabaseContext;
import com.tvd12.ezydata.database.bean.EzyAbstractRepositoriesImplementer;
import com.tvd12.ezydata.database.query.EzyQueryMethodConverter;
import com.tvd12.ezydata.database.repository.EzyMaxIdRepository;
import com.tvd12.ezydata.mongodb.EzyMongoDatabaseContext;
import com.tvd12.ezydata.mongodb.EzySimpleMongoDatabaseContext;
import com.tvd12.ezydata.mongodb.bean.EzyMongoRepositoriesImplementer;
import com.tvd12.ezydata.mongodb.converter.EzyBsonObjectIdConverter;
import com.tvd12.ezydata.mongodb.converter.EzyMongoDataConverter;
import com.tvd12.ezydata.mongodb.converter.EzyObjectIdConverter;
import com.tvd12.ezydata.mongodb.query.EzyMongoQueryFactory;
import com.tvd12.ezydata.mongodb.query.EzyMongoQueryMethodConverter;
import com.tvd12.ezydata.mongodb.repository.EzyMongoMaxIdRepository;
import com.tvd12.ezyfox.annotation.EzyId;
import com.tvd12.ezyfox.binding.EzyBindingContext;
import com.tvd12.ezyfox.binding.EzyMarshaller;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.database.annotation.EzyCollection;
import com.tvd12.ezyfox.database.annotation.EzyCollectionId;
import com.tvd12.ezyfox.naming.EzyNameTranslator;
import com.tvd12.ezyfox.naming.EzyNamingCase;
import com.tvd12.ezyfox.naming.EzySimpleNameTranslator;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyReflection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.bson.Document;

public class EzyMongoDatabaseContextBuilder
extends EzyDatabaseContextBuilder<EzyMongoDatabaseContextBuilder> {
    protected String databaseName;
    protected String maxIdCollectionName = "___max_id___";
    protected MongoClient mongoClient;
    protected Set<Class> entityClasses = new HashSet<Class>();
    protected EzyMongoDataConverter dataConverter;
    protected EzyNameTranslator collectionNameTranslator;
    protected static final String DEFAULT_MAX_ID_COLLECTION_NAME = "___max_id___";

    public EzyMongoDatabaseContextBuilder mongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
        return this;
    }

    public EzyMongoDatabaseContextBuilder databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public EzyMongoDatabaseContextBuilder maxIdCollectionName(String maxIdCollectionName) {
        this.maxIdCollectionName = maxIdCollectionName;
        return this;
    }

    public EzyMongoDatabaseContextBuilder dataConverter(EzyMongoDataConverter dataConverter) {
        this.dataConverter = dataConverter;
        return this;
    }

    public EzyMongoDatabaseContextBuilder collectionNameTranslator(EzyNameTranslator collectionNameTranslator) {
        this.collectionNameTranslator = collectionNameTranslator;
        return this;
    }

    public EzyMongoDatabaseContextBuilder collectionNameTranslator(EzyNamingCase namingCase, String ignoredSuffix) {
        return this.collectionNameTranslator((EzyNameTranslator)EzySimpleNameTranslator.builder().namingCase(namingCase).ignoredSuffix(ignoredSuffix).build());
    }

    public EzyMongoDatabaseContext build() {
        if (this.databaseName == null) {
            this.databaseName = this.properties.getProperty("database.mongo.database");
        }
        if (this.dataConverter == null) {
            this.dataConverter = EzyMongoDataConverter.builder().build();
        }
        return (EzyMongoDatabaseContext)super.build();
    }

    protected void preBuild() {
        for (EzyReflection reflection : this.reflections) {
            this.entityClasses.addAll(reflection.getAnnotatedClasses(EzyCollection.class));
            this.bindingContextBuilder.addAllClasses((Object)reflection).addClasses((Iterable)reflection.getAnnotatedClasses(EzyId.class)).addClasses((Iterable)reflection.getAnnotatedClasses(EzyCollectionId.class));
        }
        this.bindingContextBuilder.addClasses(this.entityClasses);
        this.bindingContextBuilder.addTemplate((Object)EzyObjectIdConverter.getInstance());
        this.bindingContextBuilder.addTemplate((Object)EzyBsonObjectIdConverter.getInstance());
        for (Class entityClass : this.entityClasses) {
            EzyCollectionId collectionIdAnno;
            EzyField idField = this.getCollectionIdFieldOf(entityClass);
            EzyId idAnno = (EzyId)idField.getAnnotation(EzyId.class);
            if (idAnno != null && idAnno.composite()) {
                this.bindingContextBuilder.addClass(idField.getType());
            }
            if ((collectionIdAnno = (EzyCollectionId)idField.getAnnotation(EzyCollectionId.class)) == null || !collectionIdAnno.composite()) continue;
            this.bindingContextBuilder.addClass(idField.getType());
        }
    }

    private EzyField getCollectionIdFieldOf(Class<?> entityClass) {
        EzyClass clazz = new EzyClass(entityClass);
        return (EzyField)clazz.getField(f -> f.isAnnotated(EzyCollectionId.class) || f.isAnnotated(EzyId.class)).orElseThrow(() -> new IllegalArgumentException("there is no Id field in entity class: " + entityClass.getName() + ", please annotated Id field with @EzyCollectionId or @EzyId"));
    }

    protected EzyQueryMethodConverter newQueryMethodConverter() {
        return new EzyMongoQueryMethodConverter();
    }

    protected EzySimpleDatabaseContext newDatabaseContext() {
        MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
        this.addMaxIdRepository(database);
        EzySimpleMongoDatabaseContext context = new EzySimpleMongoDatabaseContext();
        context.setClient(this.mongoClient);
        context.setDatabase(database);
        context.setDataConverter(this.dataConverter);
        context.setCollectionNameTranslator(this.getOrCreateCollectionNameTranslator());
        return context;
    }

    protected void postBuild(EzySimpleDatabaseContext ctx, EzyBindingContext bindingContext) {
        EzySimpleMongoDatabaseContext context = (EzySimpleMongoDatabaseContext)ctx;
        EzyMarshaller marshaller = bindingContext.newMarshaller();
        EzyUnmarshaller unmarshaller = bindingContext.newUnmarshaller();
        context.setMarshaller(marshaller);
        context.setUnmarshaller(unmarshaller);
        context.setQueryFactory(this.newQueryFactory(marshaller));
    }

    protected void addMaxIdRepository(MongoDatabase database) {
        try {
            EzyMongoMaxIdRepository repository = new EzyMongoMaxIdRepository((MongoCollection<Document>)database.getCollection(this.maxIdCollectionName));
            this.repositories.put(EzyMaxIdRepository.class, repository);
        }
        catch (Exception e) {
            this.logger.warn("can't create MaxIdRepository", (Throwable)e);
        }
    }

    protected EzyMongoQueryFactory newQueryFactory(EzyMarshaller marshaller) {
        return EzyMongoQueryFactory.builder().dataConverter(this.dataConverter).parameterConverter((Function)this.newQueryParameterConverter(marshaller)).build();
    }

    protected EzyAbstractRepositoriesImplementer newRepositoriesImplementer() {
        return new EzyMongoRepositoriesImplementer();
    }

    protected Function<Object, Object> newQueryParameterConverter(EzyMarshaller marshaller) {
        return param -> {
            Object data = marshaller.marshal(param);
            return this.dataConverter.dataToBsonValue(data);
        };
    }

    protected EzyNameTranslator getOrCreateCollectionNameTranslator() {
        if (this.collectionNameTranslator == null) {
            EzyNamingCase namingCase = EzyNamingCase.of((String)this.properties.getProperty("database.mongo.collection.naming.case"));
            String ignoredSuffix = this.properties.getProperty("database.mongo.collection.naming.ignored_suffix");
            this.collectionNameTranslator(namingCase, ignoredSuffix);
        }
        return this.collectionNameTranslator;
    }
}

