/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.tvd12.ezydata.database.EzySimpleDatabaseContext;
import com.tvd12.ezydata.database.query.EzyQLQuery;
import com.tvd12.ezydata.mongodb.EzyMongoDatabaseContext;
import com.tvd12.ezydata.mongodb.converter.EzyMongoDataConverter;
import com.tvd12.ezydata.mongodb.query.EzyMongoQueryFactory;
import com.tvd12.ezydata.mongodb.reflect.EzyMongoObjectProxyProvider;
import com.tvd12.ezyfox.binding.EzyMarshaller;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.naming.EzyNameTranslator;
import com.tvd12.ezyfox.reflect.EzyObjectProxy;
import com.tvd12.ezyfox.reflect.EzyObjectProxyProvider;
import lombok.Generated;
import org.bson.BsonValue;

public class EzySimpleMongoDatabaseContext
extends EzySimpleDatabaseContext
implements EzyMongoDatabaseContext {
    protected final EzyObjectProxyProvider objectProxyProvider = new EzyMongoObjectProxyProvider();
    protected MongoClient client;
    protected MongoDatabase database;
    protected EzyMarshaller marshaller;
    protected EzyUnmarshaller unmarshaller;
    protected EzyMongoQueryFactory queryFactory;
    protected EzyMongoDataConverter dataConverter;
    protected EzyNameTranslator collectionNameTranslator;

    public void close() {
        this.client.close();
    }

    @Override
    public <T> MongoCollection<T> getCollection(String name, Class<T> documentType) {
        return this.database.getCollection(name, documentType);
    }

    @Override
    public EzyQLQuery.Builder newQueryBuilder() {
        return this.queryFactory.newQueryBuilder();
    }

    @Override
    public EzyObjectProxy getObjectProxy(Class<?> objectType) {
        return this.objectProxyProvider.getObjectProxy(objectType);
    }

    @Override
    public <T> T bsonValueToData(BsonValue value, Class<T> dataType) {
        Object data = this.dataConverter.bsonValueToData(value);
        return (T)this.unmarshaller.unmarshal(data, dataType);
    }

    @Override
    public <T extends BsonValue> T dataToBsonValue(Object data) {
        Object marshalledData = this.marshaller.marshal(data);
        return this.dataConverter.dataToBsonValue(marshalledData);
    }

    @Generated
    public void setClient(MongoClient client) {
        this.client = client;
    }

    @Generated
    public void setDatabase(MongoDatabase database) {
        this.database = database;
    }

    @Generated
    public void setMarshaller(EzyMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Generated
    public void setUnmarshaller(EzyUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Generated
    public void setQueryFactory(EzyMongoQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Generated
    public void setDataConverter(EzyMongoDataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Generated
    public void setCollectionNameTranslator(EzyNameTranslator collectionNameTranslator) {
        this.collectionNameTranslator = collectionNameTranslator;
    }

    @Override
    @Generated
    public MongoClient getClient() {
        return this.client;
    }

    @Override
    @Generated
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public EzyNameTranslator getCollectionNameTranslator() {
        return this.collectionNameTranslator;
    }
}

