/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.mongodb.loader;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.tvd12.ezydata.mongodb.loader.EzyMongoClientLoader;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Map;
import java.util.Properties;

public class EzyPropertiesMongoClientLoader
extends EzyLoggable
implements EzyMongoClientLoader {
    protected Properties properties = new Properties();

    public static MongoClient load(Properties properties) {
        return new EzyPropertiesMongoClientLoader().properties(properties).load();
    }

    @Override
    public MongoClient load() {
        this.preload();
        return this.createMongoClient();
    }

    protected void preload() {
    }

    public EzyPropertiesMongoClientLoader host(String host) {
        this.properties.put("database.mongo.host", host);
        return this;
    }

    public EzyPropertiesMongoClientLoader port(int port) {
        this.properties.put("database.mongo.port", (Object)port);
        return this;
    }

    public EzyPropertiesMongoClientLoader username(String username) {
        this.properties.put("database.mongo.username", username);
        return this;
    }

    public EzyPropertiesMongoClientLoader password(String password) {
        this.properties.put("database.mongo.password", password);
        return this;
    }

    public EzyPropertiesMongoClientLoader uri(String uri) {
        this.properties.put("database.mongo.uri", uri);
        return this;
    }

    public EzyPropertiesMongoClientLoader properties(Map map) {
        this.properties.putAll((Map<?, ?>)map);
        return this;
    }

    public EzyPropertiesMongoClientLoader property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    protected MongoClient createMongoClient() {
        String uri = this.properties.getProperty("database.mongo.uri");
        if (uri != null) {
            return new MongoClient(new MongoClientURI(uri));
        }
        return new MongoClient(new ServerAddress(this.getHost(), this.getPort()), this.createCredential(), MongoClientOptions.builder().build());
    }

    protected MongoCredential createCredential() {
        return MongoCredential.createCredential((String)this.getUsername(), (String)this.getDatabase(), (char[])this.getPassword().toCharArray());
    }

    protected String getHost() {
        return (String)this.properties.getOrDefault((Object)"database.mongo.host", "127.0.0.1");
    }

    protected int getPort() {
        return Integer.parseInt(this.properties.getOrDefault((Object)"database.mongo.port", (Object)27017).toString());
    }

    protected String getUsername() {
        return (String)this.properties.get("database.mongo.username");
    }

    protected String getPassword() {
        return (String)this.properties.get("database.mongo.password");
    }

    protected String getDatabase() {
        return (String)this.properties.get("database.mongo.database");
    }
}

