/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.identifier;

import com.tvd12.ezyfox.identifier.EzyIdEncapsulationBuilder;
import com.tvd12.ezyfox.identifier.EzyIdFetcher;
import com.tvd12.ezyfox.identifier.EzyIdFetcherImplementer;
import com.tvd12.ezyfox.identifier.EzyIdFetchers;
import com.tvd12.ezyfox.identifier.EzySimpleIdFetcherImplementer;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleIdFetchers
extends EzyLoggable
implements EzyIdFetchers {
    protected Map<Class<?>, EzyIdFetcher> entityIdFetchers = new ConcurrentHashMap();

    protected EzySimpleIdFetchers(Builder builder) {
        this.entityIdFetchers.putAll(builder.entityIdFetchers);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EzyIdFetcher getIdFetcher(Class<?> clazz) {
        if (this.entityIdFetchers.containsKey(clazz)) {
            return this.entityIdFetchers.get(clazz);
        }
        throw new IllegalArgumentException("has no id fetcher for " + clazz);
    }

    @Override
    public Map<Class<?>, EzyIdFetcher> getIdFetchers() {
        return new HashMap(this.entityIdFetchers);
    }

    public static class Builder
    extends EzyIdEncapsulationBuilder<EzyIdFetchers, Builder> {
        protected Map<Class<?>, EzyIdFetcher> entityIdFetchers = new HashMap();

        public Builder addIdFetcher(Class<?> clazz, EzyIdFetcher fetcher) {
            this.entityIdFetchers.put(clazz, fetcher);
            return this;
        }

        public Builder addIdFetchers(Map<Class<?>, EzyIdFetcher> fetchers) {
            for (Class<?> key : fetchers.keySet()) {
                this.addIdFetcher(key, fetchers.get(key));
            }
            return this;
        }

        @Override
        protected EzyIdFetchers newProduct() {
            return new EzySimpleIdFetchers(this);
        }

        @Override
        protected void parseEntityClasses() {
            for (Class entityClass : this.entityClasses) {
                EzyIdFetcher fetcher = this.newIdFetcher(entityClass);
                this.entityIdFetchers.put(entityClass, fetcher);
            }
        }

        protected EzyIdFetcher newIdFetcher(Class<?> clazz) {
            EzyIdFetcherImplementer implementer = this.newIdFetcherImplementer(clazz);
            return implementer.implement();
        }

        protected EzyIdFetcherImplementer newIdFetcherImplementer(Class<?> clazz) {
            return new EzySimpleIdFetcherImplementer(clazz);
        }
    }
}

