/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.identifier;

import com.tvd12.ezyfox.identifier.EzyIdEncapsulationBuilder;
import com.tvd12.ezyfox.identifier.EzyIdSetter;
import com.tvd12.ezyfox.identifier.EzyIdSetterImplementer;
import com.tvd12.ezyfox.identifier.EzyIdSetters;
import com.tvd12.ezyfox.identifier.EzySimpleIdSetterImplementer;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EzySimpleIdSetters
extends EzyLoggable
implements EzyIdSetters {
    protected Map<Class<?>, EzyIdSetter> entityIdSetters = new ConcurrentHashMap();

    protected EzySimpleIdSetters(Builder builder) {
        this.entityIdSetters.putAll(builder.entityIdSetters);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EzyIdSetter getIdSetter(Class<?> clazz) {
        if (this.entityIdSetters.containsKey(clazz)) {
            return this.entityIdSetters.get(clazz);
        }
        throw new IllegalArgumentException("has no id setter for " + clazz);
    }

    @Override
    public Map<Class<?>, EzyIdSetter> getIdSetters() {
        return new HashMap(this.entityIdSetters);
    }

    public static class Builder
    extends EzyIdEncapsulationBuilder<EzySimpleIdSetters, Builder> {
        protected Map<Class<?>, EzyIdSetter> entityIdSetters = new HashMap();

        public Builder addIdSetter(Class<?> clazz, EzyIdSetter setter) {
            this.entityIdSetters.put(clazz, setter);
            return this;
        }

        public Builder addIdSetters(Map<Class<?>, EzyIdSetter> setters) {
            for (Class<?> key : setters.keySet()) {
                this.addIdSetter(key, setters.get(key));
            }
            return this;
        }

        @Override
        protected EzySimpleIdSetters newProduct() {
            return new EzySimpleIdSetters(this);
        }

        @Override
        protected void parseEntityClasses() {
            for (Class entityClass : this.entityClasses) {
                EzyIdSetter setter = this.newIdSetter(entityClass);
                this.entityIdSetters.put(entityClass, setter);
            }
        }

        protected EzyIdSetter newIdSetter(Class<?> clazz) {
            EzyIdSetterImplementer implementer = this.newIdSetterImplementer(clazz);
            return implementer.implement();
        }

        protected EzyIdSetterImplementer newIdSetterImplementer(Class<?> clazz) {
            return new EzySimpleIdSetterImplementer(clazz);
        }
    }
}

