/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.factory;

import com.tvd12.ezydata.redis.EzyRedisAtomicLong;
import com.tvd12.ezydata.redis.EzyRedisClient;
import com.tvd12.ezydata.redis.setting.EzyRedisSettings;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;

public class EzyRedisAtomicLongFactory {
    protected final EzyRedisSettings settings;
    protected final EzyRedisClient redisClient;

    protected EzyRedisAtomicLongFactory(Builder builder) {
        this.settings = builder.settings;
        this.redisClient = builder.redisClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EzyRedisAtomicLong newAtomicLong(String name) {
        String mapName = this.settings.getAtomicLongMapName();
        if (EzyStrings.isNoContent((String)mapName)) {
            throw new IllegalArgumentException("has no setting for atomic long map name");
        }
        return EzyRedisAtomicLong.builder().name(name).redisClient(this.redisClient).mapName(mapName).build();
    }

    public static class Builder
    implements EzyBuilder<EzyRedisAtomicLongFactory> {
        protected EzyRedisSettings settings;
        protected EzyRedisClient redisClient;

        public Builder settings(EzyRedisSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder redisClient(EzyRedisClient redisClient) {
            this.redisClient = redisClient;
            return this;
        }

        public EzyRedisAtomicLongFactory build() {
            return new EzyRedisAtomicLongFactory(this);
        }
    }
}

