/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.loader;

import com.tvd12.ezydata.database.util.EzyDatabasePropertiesKeeper;
import com.tvd12.ezydata.redis.EzyRedisClientPool;
import com.tvd12.ezydata.redis.loader.EzyRedisClientPoolLoader;

public abstract class EzyRedisAbstractClientPoolLoader<T extends EzyRedisAbstractClientPoolLoader<T>>
extends EzyDatabasePropertiesKeeper<T>
implements EzyRedisClientPoolLoader {
    protected String host;
    protected int port;
    protected String uri;

    public T host(String host) {
        this.host = host;
        return (T)this;
    }

    public T port(int port) {
        this.port = port;
        return (T)this;
    }

    public T uri(String uri) {
        this.uri = uri;
        return (T)this;
    }

    @Override
    public final EzyRedisClientPool load() {
        this.preLoad();
        return this.doLoad();
    }

    private void preLoad() {
        if (this.properties.containsKey("redis.uri")) {
            this.uri = this.properties.getProperty("redis.uri");
        }
        if (this.properties.containsKey("redis.host")) {
            this.host = this.properties.getProperty("redis.host");
        }
        if (this.properties.containsKey("redis.port")) {
            this.port = Integer.parseInt(this.properties.getOrDefault((Object)"redis.port", (Object)6379).toString());
        }
    }

    protected abstract EzyRedisClientPool doLoad();
}

