/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.manager;

import com.tvd12.ezydata.redis.EzyRedisAtomicLong;
import com.tvd12.ezydata.redis.factory.EzyRedisAtomicLongFactory;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.HashMap;
import java.util.Map;

public class EzyRedisAtomicLongProvider {
    protected final EzyRedisAtomicLongFactory atomicLongFactory;
    protected final Map<String, EzyRedisAtomicLong> atomicLongs = new HashMap<String, EzyRedisAtomicLong>();

    protected EzyRedisAtomicLongProvider(Builder builder) {
        this.atomicLongFactory = builder.atomicLongFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EzyRedisAtomicLong getAtomicLong(String name) {
        EzyRedisAtomicLong atomicLong = this.atomicLongs.get(name);
        if (atomicLong == null) {
            atomicLong = this.newAtomicLong(name);
        }
        return atomicLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EzyRedisAtomicLong newAtomicLong(String name) {
        Map<String, EzyRedisAtomicLong> map = this.atomicLongs;
        synchronized (map) {
            EzyRedisAtomicLong atomicLong = this.atomicLongs.get(name);
            if (atomicLong == null) {
                atomicLong = this.atomicLongFactory.newAtomicLong(name);
                this.atomicLongs.put(name, atomicLong);
            }
            return atomicLong;
        }
    }

    public static class Builder
    implements EzyBuilder<EzyRedisAtomicLongProvider> {
        protected EzyRedisAtomicLongFactory atomicLongFactory;

        public Builder atomicLongFactory(EzyRedisAtomicLongFactory atomicLongFactory) {
            this.atomicLongFactory = atomicLongFactory;
            return this;
        }

        public EzyRedisAtomicLongProvider build() {
            return new EzyRedisAtomicLongProvider(this);
        }
    }
}

