/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.manager;

import com.tvd12.ezydata.redis.EzyRedisChannel;
import com.tvd12.ezydata.redis.factory.EzyRedisChannelFactory;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.HashMap;
import java.util.Map;

public class EzyRedisChannelProvider {
    protected final Map<String, EzyRedisChannel> channels = new HashMap<String, EzyRedisChannel>();
    protected final EzyRedisChannelFactory channelFactory;

    protected EzyRedisChannelProvider(Builder builder) {
        this.channelFactory = builder.channelFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> EzyRedisChannel<T> getChannel(String name) {
        EzyRedisChannel<T> channel = this.channels.get(name);
        if (channel == null) {
            channel = this.newChannel(name);
        }
        return channel;
    }

    public <T> EzyRedisChannel<T> getChannel(String name, Class<T> messageType) {
        EzyRedisChannel<T> channel = this.channels.get(name);
        if (channel == null) {
            channel = this.newChannel(name, messageType);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> EzyRedisChannel<T> newChannel(String name) {
        Map<String, EzyRedisChannel> map = this.channels;
        synchronized (map) {
            EzyRedisChannel channel = this.channels.get(name);
            if (channel == null) {
                channel = this.channelFactory.newChannel(name);
                this.channels.put(name, channel);
            }
            return channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> EzyRedisChannel<T> newChannel(String name, Class<T> messageType) {
        Map<String, EzyRedisChannel> map = this.channels;
        synchronized (map) {
            EzyRedisChannel<T> channel = this.channels.get(name);
            if (channel == null) {
                channel = this.channelFactory.newChannel(name, messageType);
                this.channels.put(name, channel);
            }
            return channel;
        }
    }

    public static class Builder
    implements EzyBuilder<EzyRedisChannelProvider> {
        protected EzyRedisChannelFactory channelFactory;

        public Builder channelFactory(EzyRedisChannelFactory channelFactory) {
            this.channelFactory = channelFactory;
            return this;
        }

        public EzyRedisChannelProvider build() {
            return new EzyRedisChannelProvider(this);
        }
    }
}

