/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.redis.manager;

import com.tvd12.ezydata.redis.EzyRedisMap;
import com.tvd12.ezydata.redis.factory.EzyRedisMapFactory;
import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.HashMap;
import java.util.Map;

public class EzyRedisMapProvider {
    protected final Map<String, EzyRedisMap> maps = new HashMap<String, EzyRedisMap>();
    protected final EzyRedisMapFactory mapFactory;

    protected EzyRedisMapProvider(Builder builder) {
        this.mapFactory = builder.mapFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <K, V> EzyRedisMap<K, V> getMap(String name) {
        EzyRedisMap<K, V> map = this.maps.get(name);
        if (map == null) {
            map = this.newMap(name);
        }
        return map;
    }

    public <K, V> EzyRedisMap<K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        EzyRedisMap<K, V> map = this.maps.get(name);
        if (map == null) {
            map = this.newMap(name, keyType, valueType);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V> EzyRedisMap<K, V> newMap(String name) {
        Map<String, EzyRedisMap> map = this.maps;
        synchronized (map) {
            EzyRedisMap map2 = this.maps.get(name);
            if (map2 == null) {
                map2 = this.mapFactory.newMap(name);
                this.maps.put(name, map2);
            }
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V> EzyRedisMap<K, V> newMap(String name, Class<K> keyType, Class<V> valueType) {
        Map<String, EzyRedisMap> map = this.maps;
        synchronized (map) {
            EzyRedisMap<K, V> map2 = this.maps.get(name);
            if (map2 == null) {
                map2 = this.mapFactory.newMap(name, keyType, valueType);
                this.maps.put(name, map2);
            }
            return map2;
        }
    }

    public static class Builder
    implements EzyBuilder<EzyRedisMapProvider> {
        protected EzyRedisMapFactory mapFactory;

        public Builder mapFactory(EzyRedisMapFactory mapFactory) {
            this.mapFactory = mapFactory;
            return this;
        }

        public EzyRedisMapProvider build() {
            return new EzyRedisMapProvider(this);
        }
    }
}

